#include <iostream>
#include <iomanip>
#include <string>
#include <sstream>
#include "engine.h"
#include "board.h"
#include "squares.h"
#include "piece.h"
#include "log.h"
#include "fen.h"
#include "make.h"
#include "movegen.h"
#include "attack.h"

using namespace std;

#define FORCESIDE 3
//cXboard process;
bool cEngine::parse_move(string move)
{
  if(move.length()<4)
  {
    if(logger.islog())logger.file <<"Bad move length "<<move<<endl;
	return false;
  }

  if ((move[0] < 'a' || move[0] > 'h') || (move[1] < '1' || move[1] > '8') ||
	   (move[2] < 'a' || move[2] > 'h') || (move[3] < '1' || move[3] > '8') )
  {
	  if(logger.islog())logger.file <<"Bad move chars "<<move<<endl;
	  return false;
  }

  if(logger.islog())logger.file <<"parsing "<<move<<endl;

  uint prompce = 0;
  if(move.length()>4)
  {
	  if(move[4]=='q') { if(tree.game.getside()==cW) prompce = pwQ; else prompce = pbQ; }
	  else if(move[4]=='r') { if(tree.game.getside()==cW) prompce = pwR; else prompce = pbR; }
	  else if(move[4]=='b') { if(tree.game.getside()==cW) prompce = pwB; else prompce = pbB; }
	  else if(move[4]=='n') { if(tree.game.getside()==cW) prompce = pwN; else prompce = pbN; }
	  else
	  {
	      cout<<" UNDETECTED PROM ";
	      if(logger.islog())logger.file <<"UNDETECTED PROM "<<move<<endl;
	      return false;
      }
  }

 unsigned int from = fr2sq(chartofile(move[0]), chartorank(move[1]));
 unsigned int to = fr2sq(chartofile(move[2]), chartorank(move[3]));

 //cout<<"\n from "<<from<<" to "<<to<<endl;

 ASS(onbrd(from));
 ASS(onbrd(to));

 tree.game.setply(0);/** CRITICAL **/

 gen_all_moves(tree.game, tree.mat, tree.mlist, NULLMOVE);
 uint *list = tree.mlist.p2list(tree.game.getply());
 bool found = 0;
 uint movefound = 0;
 //cout<<"\n genned "<<tree.mlist.getcount(tree.getply())<<" moves";
 for(uint i = 0; i < tree.mlist.getcount(tree.game.getply()); ++i)
 {
   if (makemove(tree.game,tree.mat,tree.his,list[i]))
   {
     takemove(tree.game,tree.mat,tree.his);
     continue;
   }
   takemove(tree.game,tree.mat,tree.his);

  // cout<<i+1<<": "<<printmove(list[i]);

   if(FROM(list[i])==from && TO(list[i])==to)
   {
	   	if(prompce)
		{
			if(PROM(list[i])==prompce) { movefound = list[i]; found = true; break;}
		}
		else
		{
			found=true;
			movefound = list[i];
			break;
		}
   }
  }

   if(!found)
   {
	   cout<<"\n error move not found "<<move;
	   if(logger.islog())logger.file <<"error move not found "<<move<<endl;
	   return false;
   }
    if(logger.islog())logger.file <<"parsed move "<<move<<endl;

   makemove(tree.game,tree.mat,tree.his,movefound); return true;
}



bool cEngine::checkresult()
{

    if(tree.mat.drawmaterial())
    {
        cout<<"\n1/2-1/2 {insufficient material(claimed by Jabba)}"<<endl;
		if(logger.islog())logger.file <<"1/2-1/2 {insufficient material(claimed by Jabba)} "<<endl;
    }
    if (tree.game.getfifty() > 100)
    {
     cout<<"\n1/2-1/2 {fifty move rule (claimed by Jabba)}"<<endl;
	 if(logger.islog())logger.file <<"1/2-1/2 {fifty move rule (claimed by Jabba)} "<<endl;
    }
	if (tree.his.countrepetition(tree.game.getkey()) >= 2)
    {
     cout<<"\n1/2-1/2 {3-fold repetition (claimed by Jabba)}"<<endl;
	 if(logger.islog())logger.file <<"1/2-1/2 {3-fold repetition (claimed by Jabba)} "<<endl;
	}



    gen_all_moves(tree.game, tree.mat, tree.mlist, NULLMOVE);

	uint *list = tree.mlist.p2list(tree.game.getply());
	uint played = 0;// no. moves we have played
	for(uint i = 0; i < tree.mlist.getcount(tree.game.getply()); ++i)
	{
		if (makemove(tree.game,tree.mat,tree.his,list[i]))
		{
		 takemove(tree.game,tree.mat,tree.his);
		 continue;
		}
		played++;
     takemove(tree.game,tree.mat,tree.his);
	}

	if(played) return false;

	//no legal move for current side?
	bool inc = incheck(tree.game, tree.mat, tree.game.getside());

	if(inc)
	{
		if(tree.game.getside() == cW)
	    {
	      cout<<"\n0-1 {black mates (claimed by Jabba)}"<<endl;
	      if(logger.islog())logger.file <<"0-1 {black mates (claimed by Jabba)} "<<endl;
	      return true;
        }
        else
        {
          cout<<"\n1-0 {white mates (claimed by Jabba)}"<<endl;
	      if(logger.islog())logger.file <<"1-0 {white mates (claimed by Jabba)} "<<endl;
	      return true;
        }
    }
    else
    {
      cout<<"\n1/2-1/2 {stalemate (claimed by Jabba)}"<<endl;
	  if(logger.islog())logger.file <<"1/2-1/2 {stalemate (claimed by Jabba)} "<<endl;
	  return true;
    }
}

//convert the level time control string to integers
void cEngine::xboardlevel(string str, int pos)
{
   int val1=0,val2=0,val3=0,val4=0;
   str.erase(0, pos);

   //deal with time in "0:10" format
   if(str.find(':')!=-1)
   {
    string space = " ";
    str.replace(str.find(':'),1,space);
    istringstream iss(str);
    iss >> val1 >> val2 >> val3 >> val4;
    val2 = val2*60*1000 + val3*1000;
    val3 = val4*1000;
   }
   else
   {
    istringstream iss(str);
    iss >> val1 >> val2 >> val3;
    val2 = val2 * 60 * 1000;
    val3 = val3 * 1000;
   }

   //moves per session
   tree.timer.setmovestogo(val1,cW);
   tree.timer.setmovestogo(val1,cB);
   tree.timer.setmodemps(val1);
   options.moves = val1;

   //black and white time for session
   tree.timer.setsessiontime(val2,cW);
   tree.timer.setsessiontime(val2,cB);

   //increment
   tree.timer.setinc(val3,cW);
   tree.timer.setinc(val3,cB);

    //reset depth limiter
    tree.timer.setdepth(maxply);
    tree.timer.setdepthlimit(false);
}


void cEngine::startxboard()
{
    options.engineside = FORCESIDE;
    options.ponder  = false;
    options.analyzemode = false;
    tree.uci = false;
    tree.xb = true;
	sayfeatures();
}

void cEngine::sayfeatures()
{
	cout<<"\nfeature ping=1"<<endl;
	cout<<"feature setboard=1"<<endl;
	cout<<"feature usermove=1"<<endl;
	cout<<"feature time=1"<<endl;
	cout<<"feature reuse=1"<<endl;
	cout<<"feature analyze=1"<<endl;
	cout<<"feature myname=\"Jabba 1.0\""<<endl;
	cout<<"feature name=0"<<endl;
	cout<<"feature pause=0"<<endl;
	cout<<"feature playother=1"<<endl;
	cout<<"feature done=1"<<endl;
	fflush(stdout);
}


void cEngine::xboard_think()
{
   if(logger.islog())
     {
	   logger.file <<"Jabba entering think \nmovestogo "<<tree.timer.getmovestogo(cW)<<"(w) "<<tree.timer.getmovestogo(cB)<<"(b)";
	   logger.file <<"\ndepth "<<tree.timer.getdepth();
	   logger.file <<"\nwtime "<<tree.timer.getmovetime(cW);
	   logger.file <<"\nbtime "<<tree.timer.getmovetime(cB);
	   logger.file <<"\nmovetime "<<tree.timer.gettimepermove()<<"\n";
	   if(tree.his.getmoves() > 1)
	   logger.file<<"last move made "<<printmove(tree.his.lastmovemade())<<endl;
       if(onbrd(FROM(pondermove))&&onbrd(TO(pondermove)))
       {
           logger.file<<"was pondering "<<printmove(pondermove)<<endl;
           if(tree.his.lastmovemade()==pondermove)
           logger.file<<" ponderhit "<<endl;
       }
     }

    if(tree.his.lastmovemade()==pondermove)
    {
        tree.setponderhit(true);
    }
    else
    {
        tree.setponderhit(false);
    }

    pondermove = NULLMOVE;

	tree.compute();

	fflush(stdout);
	uint side = tree.game.getside();
    uint best = tree.getbestmove();
    pondermove = tree.getpondermove();

    if(logger.islog()) logger.file <<"out of compute, bestmove "<<printmove(best);
    if(logger.islog())logger.file<<" ponder "<<printmove(tree.getpondermove())<<"\n";
#ifdef DEBUG
    tree.game.logboard();
#endif
    if( !options.analyzemode )
	{
	    cout<<"\nmove "<<printmove(best)<<endl;
		cout<<"pondermove "<<printmove(tree.getpondermove())<<endl;

	    if(tree.timer.getmodemps()!=0)
	    {
	       tree.timer.decrmovestogo(side);
           if(logger.islog())logger.file <<"reduced movestogo to "<<tree.timer.getmovestogo(side)<<endl;
	    if(tree.timer.getmovestogo(side)==0)
			     tree.timer.setmovestogo(tree.timer.getmodemps(),side);
	    }
	    makemove(tree.game,tree.mat,tree.his,best);
	    checkresult();
	}
	fflush(stdout);
	logger.file.flush();
}


void cEngine::xboard_ponder()
{
	tree.setmode(smPONDER);
	tree.setponderhit(false);

	if(logger.islog())
     {
	   logger.file <<"Jabba entering ponder\n";
     }

    uint ponderme = tree.getpondermove();

    if(tree.checkmoveislegal(ponderme))
    {
        makemove(tree.game,tree.mat,tree.his,ponderme);
        tree.compute();
	    takemove(tree.game,tree.mat,tree.his);
    }
    else
    {
        tree.compute();
    }

    tree.setmode(smNONE);
	tree.timer.setpondertime();

	cout<<"pondered for "<<tree.timer.getpondertime()<<endl;
    if(logger.islog())
    {
        logger.file <<"called out of ponder, ";
        cout<<"pondered for "<<tree.timer.getpondertime()<<endl;
        logger.file.flush();
    }

}


void cEngine::process_xboard()
{
    setbuf(stdout, NULL);
    setbuf(stdout, NULL);
    setvbuf(stdin, NULL, _IONBF, 0);
    setvbuf(stdout, NULL, _IONBF, 0);

	startxboard();
	tree.timer.resettimeparam(cW);
	tree.timer.resettimeparam(cB);

	//cout<<endl;

	string input;
	char line[65536];
	char command[65536];
    input.clear();
	int pos;
	char *ptr = NULL;

    for(;;)
    {
         /*
	   when starting a new loop, need to look for some things..
	   - is our side the side to move? If so, start the thinking process
	   - is the current position a draw, mate or stalemate? if so, spit out the result claim
        */
	   fflush(stdout);
	   input.clear();

	 if((tree.game.getside() == options.engineside ||  options.analyzemode ) && !checkresult())
	 {
	       xboard_think();
	       if(options.ponder)
	       {
	           xboard_ponder();
	       }
	 }

     if(!tree.interrupted())
	 {
	     if (!fgets(line, 65535, stdin)) continue;
	     if (line[0] == '\n') continue;
         sscanf(line, "%s", command);
         ptr = line;
         while(*ptr !='\n' && *ptr != '\0')
         {
          input+=*ptr;
          *ptr++;
         }
	 }
	 else
	 {
	     input.clear();
	     tree.resetinterrupted();
	     cout<<"******* handling interrupt command ";
	     ptr = tree.hascommand();
         while(*ptr !='\n' && *ptr != '\0')
         {
          input+=*ptr;
          *ptr++;
         }
         cout<<"<"<<input<<">"<<endl;
         fflush(stdout);
	 }


	  if(findsubstr("xboard", input, pos))
	  {
	     continue;
	  }
	  if(findsubstr("accepted ", input, pos))
	  {
        continue;
	  }
	  if(findsubstr("analyze", input, pos))
	  {
        options.analyzemode=true;
        tree.setmode(smINFINITE);
        continue;
	  }
	  if(findsubstr("exit", input, pos))
	  {
        options.analyzemode=false;
        tree.setmode(smNONE);
        continue;
	  }
	  else if(findsubstr("protover", input, pos))
	  {
	      sayfeatures();
          continue;
	  }
	  else if(findsubstr("new", input, pos))
	  {
	      options.engineside = cB;
	      setepdposition(startfen,tree.game,tree.mat, tree.his);
          tree.timer.resettimeparam(cW);
	      tree.timer.resettimeparam(cB);
          continue;
	  }
	  else if(findsubstr("hard", input, pos))
	  {
	      options.ponder = true;
          continue;
	  }
	  else if(findsubstr("easy", input, pos))
	  {
	      options.ponder = false;
          continue;
	  }
	  else if(findsubstr("quit", input, pos))
	  {
	      tree.ttable.delete_tables();
          exit(0);
	  }
	  else if(findsubstr("random", input, pos))
	  {
	      continue;
	  }
	  else if(findsubstr("force", input, pos))
	  {
	      options.engineside = FORCESIDE;
          continue;
	  }
	  else if(findsubstr("go", input, pos))
	  {
	      options.engineside = tree.game.getside();
          continue;
	  }
	  else if(findsubstr("playother", input, pos))
	  {
	      options.engineside = (tree.game.getside())^1;
          continue;
	  }
	  else if(findsubstr("white", input, pos))
	  {
	    /*  tree.game.setside(cW);
	      XbOpt->engineside = cB;
	      if(logfile.islog())
			  logfile.lognum("Setting engine side to ",XbOpt->engineside);
			  */
          continue;
	  }
	  else if(findsubstr("black", input, pos))
	  {
	     /* tree.game.setside(cB);
	      XbOpt->engineside = cW;
	      if(logfile.islog())
			  logfile.lognum("Setting engine side to ",XbOpt->engineside);
          */
		  continue;
	  }
	  else if(findsubstr("level ", input, pos))
	  {
	      xboardlevel(input, pos+6);
          continue;
	  }
	  else if(findsubstr("undo", input, pos))
	  {
	      if(tree.his.getmoves()>0)
		  {
			  takemove(tree.game,tree.mat,tree.his);
		  }
	      else
		  {
	       continue;
		  }
	  }
	  else if(findsubstr("sd ", input, pos))
	  {
	      tree.timer.setdepth(strtoint(input, pos+3));
          tree.timer.setmodetpm(false);
          tree.timer.setmodemtg(false);
          tree.timer.setdepthlimit(true);
          continue;
	  }
	  else if(findsubstr("st ", input, pos))
	  {
	      tree.timer.settimepermove(strtoint(input, pos+3)*1000);
          tree.timer.setmodetpm(true);
          tree.timer.setmodemtg(false);
          tree.timer.setdepthlimit(false);
          tree.timer.setdepth(maxply);
          continue;
	  }
	  else if(findsubstr("time ", input, pos))
	  {
          //cout<<"***************time recog ("<<input<<")"<<endl;
          fflush(stdout);
          tree.timer.setmodetpm(false);
          tree.timer.setdepth(maxply);
		  if(options.engineside==cW)
	      {
	          tree.timer.setmovetime(strtoint(input, pos+5)*10, cW);//note the *10 !!! xboard time comes in centiseconds
          }
	      else
	      {
	          tree.timer.setmovetime(strtoint(input, pos+5)*10, cB);//note the *10 !!! xboard time comes in centiseconds
          }
	      continue;
	  }
	  else if(findsubstr("otim ", input, pos))
	  {
	     // cout<<"*******************otim recog ("<<input<<")"<<endl;
	      fflush(stdout);
	      if(options.engineside==cW)
	      {
	          tree.timer.setmovetime(strtoint(input, pos+5)*10, cB);//note the *10 !!! xboard time comes in centiseconds
          }
	      else
	      {
	          tree.timer.setmovetime(strtoint(input, pos+5)*10, cW);//note the *10 !!! xboard time comes in centiseconds
	      }
	      continue;
	  }
	  else if(findsubstr("ping ", input, pos))
	  {
	      cout<<"pong "<<strtoint(input, pos+4)<<endl;
	      continue;
	  }
	  else if(findsubstr("usermove ", input, pos))
	  {
	      input.erase(0, input.find("usermove ")+9);
	      if(!parse_move(input))
	      {
	          cout<<"\n not understood move "<<input<<endl;
			  continue;
	      }
	      continue;
	  }
	  else if(findsubstr("print", input, pos))
	  {
	      tree.game.printboard();
	      tree.mat.printmaterial();
	      cout<<endl;
	      continue;
	  }
	  else if(findsubstr("setboard ", input, pos))
	  {
	      input.erase(0, 9);
		  setepdposition(input.c_str(),tree.game,tree.mat,tree.his);
	      continue;
	  }
	  else if(findsubstr("clearhash", input, pos))
	  {
          tree.ttable.reset_tables();
          continue;
	  }
	  else if(findsubstr("perftfile", input, pos))
	  {
	   tree.his.clearhistory();
       tree.timer.resettimeparam(cW);
	   tree.timer.resettimeparam(cB);
	   tree.setmode(smPERFTFILE);
	   continue;
	  }
	  else if(findsubstr("eval", input, pos))
	  {
		 int ss = tree.scorer.eval(tree.game, tree.mat, tree.ptab);
		 cout<<"\n eval score: "<<ss;
		 cout<<"\n normalised : "<<cpscore(ss);
		 cout<<endl;
		 continue;
	  }
	  else if(findsubstr("fenstr", input, pos))
	  {
		 cout<<"\n";
		 cout<<fenfromboard(tree.game,tree.mat);
		 continue;
	  }
	}//end of while loop
}





